﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace PI.ZB.N1200.ELearning.WebApplication.Statistics
{
    public abstract class StatsPanel
    {
        public enum EditModeType
        {
            NotLoaded = -1,
            None = 0,
            EditOrInsert = 1,
            Remove = 2,
        }

        private StatsBaseComponent _Component = null;

        protected StatsBaseComponent Component
        {
            get
            {
                return _Component;
            }
        }

        public StatsPanel(StatsBaseComponent BaseComponent)
        {
            _Component = BaseComponent;
        }

        public abstract void Load();
        public abstract bool Save();

        private EditModeType _editMode = EditModeType.NotLoaded;
        protected EditModeType EditMode
        {
            get
            {
                if (_editMode == EditModeType.NotLoaded)
                {
                    _editMode = EditModeType.None;
                    try
                    {
                        _editMode = (EditModeType)Component.Environment.GetRequestParamInt("editmode");
                    }
                    catch { }
                }
                return _editMode;
            }
        }
    }
}